
******************************************************************
*
* PANEL-ANALYSIS (using (deterministic) simulated data)
*
* JOSEF BRÜDERL, UNIVERSITY OF MUNICH, March 2019
*
******************************************************************

* This DO-File contains the STATA commands for the FEIS demonstration
* 

* These are the variables in the dataset:
* id    person identifier
* time  # panel wave
* age   age in years


*************************************
** Preliminaries    *****************
*************************************
clear 
set more off

* Load data
cd  "C:\Users\bruederl\LRZ Sync+Share\Vorlesung PDA\Stata Beispiele\Artificial Data\"    //Adapt this path!
use "Wage Premium 2.dta", clear

*****************************************************
***  FEIS Simulation
*****************************************************

* Treatment: marriage dummy
gen marr=0                                              // Treatment
replace marr=1  if id==3 & time>3
replace marr=1  if id==4 & time>3

* Treatment effect is +500
* Heterogenous growth: slopes are 100, 150, 200, 250
gen wage=0                                              // Outcome
replace wage = -1000 + age*100 + marr*500  if id==1
replace wage = -1500 + age*150 + marr*500  if id==2
replace wage = -1500 + age*200 + marr*500  if id==3
replace wage = -1500 + age*250 + marr*500  if id==4


* Plotting the data
twoway  (scatter wage age, ylabel(0(1000)6000, grid angle(0))            ///
                 ymtick(500(1000)5500, grid) c(L))                       ///
        (scatter wage age if marr==1, c(L)),                             ///
        legend(label(1 "before marriage") label(2 "after marriage") pos(6) ring(0))

		
* Panel Analysis
xtset id time

xtreg  wage marr age             , fe     // FE
xtfeis wage marr, slope(age)              // FEIS


reg wage marr  ibn.id           age, noconstant     // LSDV
reg wage marr  ibn.id  ibn.id#c.age, noconstant     // POLSIS



* Including the counterfactual wage trend
twoway  (scatter wage age, ylabel(0(1000)6000, grid angle(0))            ///
                 ymtick(500(1000)5500, grid) c(L))                       ///
        (scatter wage age if marr==1, c(L))                              ///
		(function y = -1978 + 142.5*x, range(20 26) lcolor(blue) lpattern(dash))          ///
		(function y = -1302 + 142.5*x, range(24 29) lcolor(blue) lpattern(dash))          ///
		(function y =  -175 + 142.5*x, range(23 27) lcolor(blue) lpattern(dash))          ///
		(function y =   919 + 142.5*x, range(21 27) lcolor(blue) lpattern(dash))          ///
		(function y = -1500 +   200*x, range(23 27) lcolor(black) lpattern(dash))          ///
		(function y = -1500 +   250*x, range(21 27) lcolor(black) lpattern(dash)),          ///
        legend(order(3 "counterfactual wage profile (FE)" 7 "counterfactual wage profile (FEIS)") ///
		       rows(2) pos(5) ring(0))  xtitle(age) ytitle(wage)

		
*****************************************************
***  Does FEIS Overcontrol?
*****************************************************

gen marrdur=0
replace marrdur=1  if id>2 & time==4
replace marrdur=2  if id>2 & time==5
replace marrdur=3  if id>2 & time==6
replace marrdur=4  if id>2 & time==7

gen mdur1 = marrdur==1    // Dummies needed below
gen mdur2 = marrdur==2
gen mdur3 = marrdur==3
gen mdur4 = marrdur==4


* Treatment effect is 0, +250, +500, +750
* Heterogenous growth: slopes are 100, 150, 200, 250
gen wage1=0                                              // Outcome
replace wage1 = -1000 + age*100                                      if id==1
replace wage1 = -1500 + age*150                                      if id==2
replace wage1 = -1500 + age*200 + mdur2*250 + mdur3*500              if id==3
replace wage1 = -1500 + age*250 + mdur2*250 + mdur3*500 + mdur4*750  if id==4


* Plotting the data
twoway  (scatter wage1 age, ylabel(0(1000)6000, grid angle(0))            ///
                 ymtick(500(1000)5500, grid) c(L))                       ///
        (scatter wage1 age if marr==1, c(L)),                             ///
        legend(label(1 "before marriage") label(2 "after marriage") pos(6) ring(0))

		
xtreg  wage1 i.marrdur age             , fe     // FE
xtfeis wage1 mdur?, slope(age)                  // FEIS (factor variables not allowed)

reg wage1 i.marrdur  ibn.id  ibn.id#c.age, noconstant     // POLSIS

* Including the counterfactual wage trend
twoway  (scatter wage1 age, ylabel(0(1000)6000, grid angle(0))            ///
                 ymtick(500(1000)5500, grid) c(L))                       ///
        (scatter wage1 age if marr==1, c(L))                              ///
		(function y = -1500 +   200*x, range(23 27) lcolor(black) lpattern(dash))          ///
		(function y = -1500 +   250*x, range(21 27) lcolor(black) lpattern(dash)),          ///
        legend(order(3 "counterfactual wage profile (FEIS)") ///
		       pos(5) ring(0))  xtitle(age) ytitle(wage)


